<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Database\Seeders\WebOrderingDemoSeeder;

class SeedWebOrderingDemo extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'seed:web-ordering-demo';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Seed demo data for web ordering: 5 restaurants with branches, menu items, and customers';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('🌱 Seeding demo data for web ordering...');
        $this->newLine();

        $seeder = new WebOrderingDemoSeeder();
        $seeder->setCommand($this);
        $seeder->run();

        $this->newLine();
        $this->info('✅ Demo data seeding completed!');
        
        return Command::SUCCESS;
    }
}
