<?php

use Illuminate\Support\Facades\Route;
use Modules\MultiPOS\Http\Controllers\MultiPOSController;
use Modules\MultiPOS\Http\Controllers\SettingsController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::middleware(['auth'])->group(function () {
    Route::prefix('multi-pos')->name('multi-pos.')->group(function () {
        // Settings/Management routes
        Route::middleware(['can:Manage MultiPOS Machines'])->group(function () {
            Route::get('/settings', [SettingsController::class, 'index'])->name('settings');
            Route::post('/machines/{machine}/approve', [SettingsController::class, 'approve'])->name('machines.approve');
            Route::post('/machines/{machine}/decline', [SettingsController::class, 'decline'])->name('machines.decline');
            Route::put('/machines/{machine}', [SettingsController::class, 'update'])->name('machines.update');
            Route::delete('/machines/{machine}', [SettingsController::class, 'destroy'])->name('machines.destroy');
            
            // Reports routes
            Route::get('/reports/machine-report', function () {
                return view('multipos::reports.machine-report');
            })->name('reports.machine-report');
        });
    });
});
