<?php

return [
    'registration' => [
        'title' => 'Register This Device as a POS',
        'description' => 'To use the POS system, this device must be registered. All orders will be linked to this device.',
        'branch_required' => 'Please select a branch',
        'alias_label' => 'Device Name (Optional)',
        'alias_hint' => 'Give this device a friendly name for easy identification.',
        'register_button' => 'Register Device',
        'cancel_button' => 'Cancel & Go Back',
        'registered_successfully' => 'Device registered successfully! Waiting for admin approval.',
        'already_registered' => 'This device is already registered.',
        'limit_reached' => [
            'title' => 'Machine Limit Reached',
            'message' => 'You have reached the maximum number of POS machines allowed for this branch (:limit). Please contact your administrator.',
        ],
        'pending_approval' => 'Your device registration is pending approval. Please wait for admin approval.',
    ],

    'status' => [
        'pending' => 'Pending',
        'active' => 'Active',
        'declined' => 'Declined',
        'pending_description' => 'Awaiting approval',
        'active_description' => 'Approved and can process orders',
        'declined_description' => 'Access denied, please contact administrator',
    ],

    'actions' => [
        'approve' => 'Approve',
        'decline' => 'Decline',
        'edit' => 'Edit',
        'delete' => 'Delete',
        'approved_successfully' => 'Machine approved successfully',
        'declined_successfully' => 'Machine declined successfully',
        'updated_successfully' => 'Machine updated successfully',
        'deleted_successfully' => 'Machine deleted successfully',
        'approval_failed' => 'Failed to approve machine',
        'decline_failed' => 'Failed to decline machine',
        'can_only_approve_pending' => 'Only pending machines can be approved',
        'can_only_decline_pending' => 'Only pending machines can be declined',
        'machine_not_found' => 'Machine not found',
    ],

    'settings' => [
        'title' => 'MultiPOS Settings',
        'subtitle' => 'Manage and configure your POS machines',
        'machine_registration_title' => 'Machine Registration',
        'machine_registration_description' => 'When users access the POS page without a registered device, they\'ll be prompted to register it. New registrations appear as "Pending" and require approval.',
        'status_guide_title' => 'Status Guide',
        'registered_machines' => 'Registered Machines for Branch: :branch',
        'no_machines' => 'No machines registered yet',
        'machine_count' => 'Total Machines: :count',
        'remaining_slots' => 'Remaining Slots: :slots',
        'unlimited' => 'Unlimited',
    ],

    'table' => [
        'alias' => 'ALIAS',
        'machine_id' => 'MACHINE ID',
        'status' => 'STATUS',
        'last_seen' => 'LAST SEEN',
        'registered' => 'REGISTERED',
        'actions' => 'ACTIONS',
    ],

    'package' => [
        'multipos_limit' => 'MultiPOS Limit',
        'multipos_limit_info' => 'Maximum number of POS machines allowed per branch. Set to -1 for unlimited.',
    ],
];

