<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('pos_machines')) {
            Schema::create('pos_machines', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('restaurant_id');
                $table->unsignedBigInteger('branch_id');
                $table->string('device_id', 100)->unique()->index();
                $table->string('alias')->nullable();
                $table->enum('status', ['pending', 'active', 'declined'])->default('pending')->index();
                $table->unsignedBigInteger('registered_by');
                $table->unsignedBigInteger('approved_by')->nullable();
                $table->timestamp('approved_at')->nullable();
                $table->unsignedBigInteger('declined_by')->nullable();
                $table->timestamp('declined_at')->nullable();
                $table->text('declined_reason')->nullable();
                $table->timestamp('last_seen_at')->nullable()->index();
                $table->timestamp('registered_at')->nullable();
                $table->timestamps();
                $table->softDeletes();

                // Foreign keys
                $table->foreign('restaurant_id')->references('id')->on('restaurants')->onDelete('cascade');
                $table->foreign('branch_id')->references('id')->on('branches')->onDelete('cascade');
                $table->foreign('registered_by')->references('id')->on('users')->onDelete('cascade');
                $table->foreign('approved_by')->references('id')->on('users')->onDelete('set null');
                $table->foreign('declined_by')->references('id')->on('users')->onDelete('set null');

                // Indexes for common queries
                $table->index(['restaurant_id', 'branch_id', 'status'], 'pos_machines_restaurant_branch_status_index');
                $table->index('registered_at');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pos_machines');
    }
};
