<?php

namespace Modules\Inventory\Observers;

use Modules\Inventory\Entities\Unit;
use Modules\Inventory\Services\InventoryCacheService;

class UnitObserver
{

    public function creating(Unit $unit)
    {
        if (branch()) {
            $unit->branch_id = branch()->id;
        }
    }

    public function created(Unit $unit): void
    {
        // Clear branch cache when unit is created
        InventoryCacheService::clearBranchCache($unit->branch_id);
    }

    public function updated(Unit $unit): void
    {
        // Clear branch cache when unit is updated
        InventoryCacheService::clearBranchCache($unit->branch_id);
        
        // Also clear if branch changed
        if ($unit->isDirty('branch_id')) {
            InventoryCacheService::clearBranchCache($unit->getOriginal('branch_id'));
        }
    }

    public function deleted(Unit $unit): void
    {
        // Clear branch cache when unit is deleted
        InventoryCacheService::clearBranchCache($unit->branch_id);
    }
}
