<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (Schema::hasTable('menu_items')) {
            Schema::table('menu_items', function (Blueprint $table) {
                if (!Schema::hasColumn('menu_items', 'batch_recipe_id')) {
                    $table->unsignedBigInteger('batch_recipe_id')->nullable()->after('in_stock');
                }
                // Check if foreign key exists before adding
                if (Schema::hasTable('batch_recipes')) {
                    $foreignKeys = \DB::select("SELECT CONSTRAINT_NAME FROM information_schema.TABLE_CONSTRAINTS WHERE CONSTRAINT_TYPE = 'FOREIGN KEY' AND TABLE_NAME = 'menu_items' AND CONSTRAINT_NAME = 'menu_items_batch_recipe_id_foreign'");
                    if (empty($foreignKeys)) {
                        $table->foreign('batch_recipe_id')->references('id')->on('batch_recipes')->onDelete('set null')->onUpdate('cascade');
                    }
                }
                
                if (!Schema::hasColumn('menu_items', 'batch_serving_size')) {
                    $table->decimal('batch_serving_size', 16, 2)->nullable()->after('batch_recipe_id'); // e.g., 0.15 L per cup
                }
            });
        }
        
        if (Schema::hasTable('menu_item_variations')) {
            Schema::table('menu_item_variations', function (Blueprint $table) {
                if (!Schema::hasColumn('menu_item_variations', 'batch_recipe_id')) {
                    $table->unsignedBigInteger('batch_recipe_id')->nullable()->after('price');
                }
                // Check if foreign key exists before adding
                if (Schema::hasTable('batch_recipes')) {
                    $foreignKeys = \DB::select("SELECT CONSTRAINT_NAME FROM information_schema.TABLE_CONSTRAINTS WHERE CONSTRAINT_TYPE = 'FOREIGN KEY' AND TABLE_NAME = 'menu_item_variations' AND CONSTRAINT_NAME = 'menu_item_variations_batch_recipe_id_foreign'");
                    if (empty($foreignKeys)) {
                        $table->foreign('batch_recipe_id')->references('id')->on('batch_recipes')->onDelete('set null')->onUpdate('cascade');
                    }
                }
                
                if (!Schema::hasColumn('menu_item_variations', 'batch_serving_size')) {
                    $table->decimal('batch_serving_size', 16, 2)->nullable()->after('batch_recipe_id');
                }
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('menu_items', function (Blueprint $table) {
            $table->dropForeign(['batch_recipe_id']);
            $table->dropColumn(['batch_recipe_id', 'batch_serving_size']);
        });
        
        Schema::table('menu_item_variations', function (Blueprint $table) {
            $table->dropForeign(['batch_recipe_id']);
            $table->dropColumn(['batch_recipe_id', 'batch_serving_size']);
        });
    }
};

