<?php

namespace Modules\CashRegister\Entities;

use Illuminate\Database\Eloquent\Model;

class CashRegisterTransaction extends Model
{
    protected $fillable = [
        'cash_register_session_id',
        'restaurant_id',
        'branch_id',
        'happened_at',
        'type',
        'reference',
        'reason',
        'amount',
        'running_amount',
        'created_by',
        'order_id',
        'currency_code',
    ];

    protected $casts = [
        'happened_at' => 'datetime',
    ];

    public function session()
    {
        return $this->belongsTo(CashRegisterSession::class, 'cash_register_session_id');
    }
}


