<?php

namespace Modules\CashRegister\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class CashRegisterCount extends Model
{
    protected $fillable = [
        'cash_register_session_id',
        'cash_denomination_id',
        'count',
        'subtotal',
    ];

    public function denomination(): BelongsTo
    {
        return $this->belongsTo(\Modules\CashRegister\Entities\Denomination::class, 'cash_denomination_id');
    }
}


